// CLibTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <conio.h>
#include "..\NUCLib.h"

int _tmain(int argc, _TCHAR* argv[])
{
	printf("HIT <Esc> TO EXIT!\n");

	int state;

	nucOpenDeviceHandler(1000);
	if (isNUCConnected())
	{
		printf("NUC opened!\n");
		Sleep(500);	//it's recommended to give a few miliseconds before the first read otherwise the first read might be 0 

		//the library reads the NUC values in every 1000 msec (once per second)
		//therefore is useless to read them faster from here

		char path[1024];
		getNUCDevicePath(path);
		
		printf(" firmware: %02d.%02d \n",getNUCVerMajor(),getNUCVerMinor());
		printf(" mode: %d\n",getNUCMode());
		printf(" path: %s\n",path);
		printf("------------------------------\n");
	}
	else printf("NUC not found!\n");

	char ch = 0;

	while (ch != 27)
	{
		if (_kbhit())
		{
			ch = _getch();
			if (ch != 27)
			{
				printf("Press again:\n");
				printf("L.Load flash\nQ.Set flash 1\nW.Set flash 2\nA.Save settings to file\nS.Load settings from file\n");
				ch = _getch();
				switch (ch)
				{
				case 'l':
				case 'L': 
					{
						printf("Loading flash values. Wait ...\n");
						startNUCLoadingSettings(0,0);
						int timeout = 0;
						while ((getNUCLoadingSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						{
							printf("Loading %d%c\n",getNUCLoadingSettingsState(),'%');
							timeout++;
							Sleep(500);
						}
						printf("Loading final: %d%c\n",getNUCLoadingSettingsState(),'%');//100=OK, F0-FF=ERRORCODE
						if (getNUCLoadingSettingsState() == 100)//succesfull
						{
							unsigned int var_max = getNUCMaxVariableCnt();
							char name[256];
							char value[256];
							char unit[256];
							char comment[1024];

							for (int i=0;i<var_max;i++)
								if (getNUCVariableData(i, name, value, unit, comment))
									printf("[%d] %s=%s %s\n",i,name, value, unit);//, comment);
						}
						else printf("    ERROR: %02x", getNUCLoadingSettingsState());
					}break;
				case 'a':
				case 'A':
					{
						printf("Saving flash values to file. Wait ...\n");
						startNUCLoadingSettings(1,0);
						int timeout = 0;
						while ((getNUCLoadingSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						{
							printf("Loading %d%c\n",getNUCLoadingSettingsState(),'%');
							timeout++;
							Sleep(500);
						}
						printf("Loading final: %d%c\n",getNUCLoadingSettingsState(),'%');//100=OK, F0-FF=ERRORCODE
					}break;
				case 's':
				case 'S':
					{
						printf("Loading flash values from file. Wait ...\n");
						startNUCSaveSettings(1);
						int timeout = 0;
						while ((getNUCSaveSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						{
							printf("Saving %d%c\n",getNUCSaveSettingsState(),'%');
							timeout++;
							Sleep(500);
						}
						printf("Saving final: %d%c\n",getNUCSaveSettingsState(),'%');//100=OK, F0-FF=ERRORCODE
					}break;
				case 'q':
				case 'Q':
				case 'w':
				case 'W':
					if ((ch == 'q') || (ch == 'Q'))
					{
						setNUCVariableData(23, "3111");//POUT_HIGH_THRESHOLD
						setNUCVariableData(22, "11111111");//CONFIG2
					}
					else
					{
						setNUCVariableData(23, "3000");//POUT_HIGH_THRESHOLD
						setNUCVariableData(22, "00000000");//CONFIG2
					}

					startNUCSaveSettings(0);
					int timeout = 0;
					while ((getNUCSaveSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
					{
						printf("Saving %d%c\n",getNUCSaveSettingsState(),'%');
						timeout++;
						Sleep(500);
					}
					printf("Saving final: %d%c\n",getNUCSaveSettingsState(),'%');//100=OK, F0-FF=ERRORCODE
					break;
				}
			}
		}
		else
		{
			if (isNUCConnected() == false)
			{
				//NUCCloseDeviceHandler();//close it only if you do not want auto reconnect
				printf("No device\n");
			}
			else
			{
				printf("MD=%d ",getNUCMode());
				printf("VIn=%.2f ",getNUCVIn());
				printf("IIn=%.2f ",getNUCIIn());
				printf("VOut=%.2f ",getNUCVOut());
				printf("IOut=%.2f ",getNUCIOut());
				if (getNUCTemperature() >= 1000)
					 printf("Tmp=--- ");
				else printf("Tmp=%.2f ",getNUCTemperature());
				printf("VIgn=%.2f ",getNUCVIgnition());
				printf("POut=%.2f ",getNUCPOut());
				printf("VTh=%.2f\n",getNUCVThump());
			}
			Sleep(1000);
		}
	}//while
	nucCloseDeviceHandler();

	return 0;
}

